from enum import IntEnum
from enum import IntFlag

# Import enums for the Sequence Generator. Also if not used in here, so other modules can import them.
from devicepilot.meas_sequences.sequence_generator import SequenceGenerator
from devicepilot.meas_sequences.sequence_generator import IntegratorMode
from devicepilot.meas_sequences.sequence_generator import AnalogControlMode
from devicepilot.meas_sequences.sequence_generator import AnalogRange
from devicepilot.meas_sequences.sequence_generator import SetRegisterCondition


class TriggerInput(IntFlag):
    TRFLow  = 1 << 1
    TRFHigh = 1


class TriggerOutput(IntFlag):
    TRF        = 1 << 8
    SamplePD4  = 1 << 7
    SamplePD3  = 1 << 6
    SamplePD2  = 1 << 5
    SamplePD1  = 1 << 4
    SamplePMT2 = 1 << 1
    SamplePMT1 = 1


class SignalOutput(IntEnum):
    Flash         = 1 << 23
    Alpha         = 1 << 22
    HTSAlpha      = 1 << 21
    InputGatePMT2 = 1 << 17
    InputGatePMT1 = 1 << 16
    HVGatePMT2    = 1 << 13
    HVGatePMT1    = 1 << 12
    HVOnUSLUM     = 1 << 10
    HVOnPMT2      = 1 << 9
    HVOnPMT1      = 1 << 8


class MeasurementChannel(IntEnum):
    PMT1     = 0
    PMT2     = 1
    PMTUSLUM = 2
    PD1REF   = 4
    PD2ABS   = 5
    PD3AUX   = 6
    PD4      = 7


class EEFSequenceGenerator(SequenceGenerator):

    def set_integrator_mode(self, pmt1: IntegratorMode = 0, pmt2: IntegratorMode = 0,
                            pd1ref: IntegratorMode = 0, pd2abs: IntegratorMode = 0,
                            pd3aux: IntegratorMode = 0, pd4: IntegratorMode = 0):
        super().set_integrator_mode(channel0=pmt1, channel1=pmt2, channel4=pd1ref, channel5=pd2abs, channel6=pd3aux, channel7=pd4)

    def set_analog_control(self, pmt1: AnalogControlMode = 0, pmt2: AnalogControlMode = 0,
                            pd1ref: AnalogControlMode = 0, pd2abs: AnalogControlMode = 0,
                            pd3aux: AnalogControlMode = 0, pd4: AnalogControlMode = 0):
        super().set_analog_control(channel0=pmt1, channel1=pmt2, channel4=pd1ref, channel5=pd2abs, channel6=pd3aux, channel7=pd4)
